local cockpit = folder.."../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")

join(res.keyCommands, {

-- Systems

	{down = Keys.LogDataPoint, name = _('Log Single Data Point'), category = _('Systems')}, 
    {down = Keys.ToggleDoors, name = _('Open/close Door'), category = _('Systems')}, 
	
	--{down = Keys.StartLateralFT, name = _('Lateral dynamic'), category = _('Flighttests')}, 
	--{down = Keys.StartLongFT, name = _('Longitudinal dynamic'), category = _('Flighttests')}, 

    {down = Keys.BattSwitchBatt, name = _('Battery Switch BAT'), category = _('Systems')},
    {down = Keys.BattSwitchOff, name = _('Battery Switch OFF'), category = _('Systems')},
	{down = Keys.BattSwitchExt, name = _('Battery Switch EXT'), category = _('Systems')},

-- Electric System-------
    {down = Keys.gen_on, name = _('Generator On'), category = _('Systems')},
    {down = Keys.gen_off, name = _('Generator Off'), category = _('Systems')},
    {down = Keys.gen_toggle, name = _('Generator Toggle'), category = _('Systems')},
    {down = Keys.inverter_on, name = _('Inverter On'), category = _('Systems')},
    {down = Keys.inverter_off, name = _('Inverter Off'), category = _('Systems')},
    {down = Keys.inverter_toggle, name = _('Inverter Toggle'), category = _('Systems')},
    {down = Keys.att_ind_on, name = _('Attitude Indicator On'), category = _('Systems')},
    {down = Keys.att_ind_off, name = _('Attitude Indicator Off'), category = _('Systems')},
    {down = Keys.att_ind_toggle, name = _('Attitude Indicator Toggle'), category = _('Systems')},
    {down = Keys.start_pump_on, name = _('Start Pump On'), category = _('Systems')},
    {down = Keys.start_pump_off, name = _('Start Pump Off'), category = _('Systems')},
    {down = Keys.start_pump_toggle, name = _('Start Pump Toggle'), category = _('Systems')},
    {down = Keys.pitot_on, name = _('Pitotheating On'), category = _('Systems')},
    {down = Keys.pitot_off, name = _('Pitotheating Off'), category = _('Systems')},
    {down = Keys.pitot_toggle, name = _('Pitotheating Toggle'), category = _('Systems')},
    {down = Keys.scavair_on, name = _('Scav Air On'), category = _('Systems')},
    {down = Keys.scavair_off, name = _('Scav Air Off'), category = _('Systems')},
    {down = Keys.scavair_toggle, name = _('Scav Air Toggle'), category = _('Systems')},
    {down = Keys.masterradio_on, name = _('Master Radio On'), category = _('Systems')},
    {down = Keys.masterradio_off, name = _('Master Radio Off'), category = _('Systems')},
    {down = Keys.masterradio_toggle, name = _('Master Radio Toggle'), category = _('Systems')},
    {down = Keys.antiice_on, name = _('Anti Ice On'), category = _('Systems')},
    {down = Keys.antiice_off, name = _('Anti Ice Off'), category = _('Systems')},
    {down = Keys.antiice_toggle, name = _('Anti Ice Toggle'), category = _('Systems')},

-- FuelSystem
    {down = Keys.fuel_valve_on, name = _('Fuel Valve Open'), category = _('Systems')},
    {down = Keys.fuel_valve_off, name = _('Fuel Valve Close'), category = _('Systems')},
    {down = Keys.fuel_valve_toggle, name = _('Fuel Valve Toggle'), category = _('Systems')},
    {down = Keys.fuel_transfer_on, name = _('Fuel Transfer On'), category = _('Systems')},
    {down = Keys.fuel_transfer_off, name = _('Fuel Transfer Off'), category = _('Systems')},
    {down = Keys.fuel_transfer_toggle, name = _('Fuel Transfer Toggle'), category = _('Systems')},
    {down = Keys.fuel_aux, name = _('Fuel Indicator Aux'), category = _('Systems')},

-- Basic Indicators
    {pressed = Keys.inc_baroalt_pressure, name = _('Barometric Altitude Pressure Increase'), category = _('Systems')},
    {pressed = Keys.dec_baroalt_pressure, name = _('Barometric Altitude Pressure Decrease'), category = _('Systems')},
    {pressed = Keys.inc_radaralt_low, name = _('Radar Altitude Low Increase'), category = _('Systems')},
    {pressed = Keys.dec_radaralt_low, name = _('Radar Altitude Low Decrease'), category = _('Systems')},
    {pressed = Keys.inc_radaralt_high, name = _('Radar Altitude High Increase'), category = _('Systems')},
    {pressed = Keys.dec_radaralt_high, name = _('Radar Altitude High Decrease'), category = _('Systems')},

-- ANARC182 
    {down = Keys.arc182_10mhz_up, name = _('ANARC182 10MHz Increase'), category = _('Communications')},
    {down = Keys.arc182_10mhz_down, name = _('ANARC182 10MHz Decrease'), category = _('Communications')},
    {down = Keys.arc182_1mhz_up, name = _('ANARC182 1MHz Increase'), category = _('Communications')},
    {down = Keys.arc182_1mhz_down, name = _('ANARC182 1MHz Decrease'), category = _('Communications')},
    {down = Keys.arc182_100khz_up, name = _('ANARC182 100KHz Increase'), category = _('Communications')},
    {down = Keys.arc182_100khz_down, name = _('ANARC182 100KHz Decrease'), category = _('Communications')},
    {down = Keys.arc182_10khz_up, name = _('ANARC182 10KHz Increase'), category = _('Communications')},
    {down = Keys.arc182_10khz_down, name = _('ANARC182 10KHz Decrease'), category = _('Communications')},
    {down = Keys.arc182_am, name = _('ANARC182 Modulation AM'), category = _('Communications')},
    {down = Keys.arc182_fm, name = _('ANARC182 Modulation FM'), category = _('Communications')},
    {down = Keys.arc182_amfm_toogle, name = _('ANARC182 Modulation Toggle'), category = _('Communications')},

    {pressed = Keys.arc182_vol_inc, name = _('ANARC182 Volume Increase'), category = _('Communications')},
    {pressed = Keys.arc182_vol_dec, name = _('ANARC182 Volume Decrease'), category = _('Communications')},
    {pressed = Keys.arc182_brt_inc, name = _('ANARC182 Brightness Increase'), category = _('Communications')},
    {pressed = Keys.arc182_brt_dec, name = _('ANARC182 Brightness Decrease'), category = _('Communications')},

    {down = Keys.arc182_freq_mode_inc, name = _('ANARC182 Frequency Mode Increase'), category = _('Communications')},
    {down = Keys.arc182_freq_mode_dec, name = _('ANARC182 Frequency Mode Decrease'), category = _('Communications')},
    {down = Keys.arc182_mode_inc, name = _('ANARC182 Mode Increase'), category = _('Communications')},
    {down = Keys.arc182_mode_dec, name = _('ANARC182 Mode Decrease'), category = _('Communications')},

-- ANARC186
    {pressed = Keys.arc186_vol_inc, name = _('ANARC186 Volume Increase'), category = _('Communications')},
    {pressed = Keys.arc186_vol_dec, name = _('ANARC186 Volume Decrease'), category = _('Communications')},
    {down = Keys.arc186_10mhz_up, name = _('ANARC186 10MHz Increase'), category = _('Communications')},
    {down = Keys.arc186_10mhz_down, name = _('ANARC186 10MHz Decrease'), category = _('Communications')},
    {down = Keys.arc186_1mhz_up, name = _('ANARC186 1MHz Increase'), category = _('Communications')},
    {down = Keys.arc186_1mhz_down, name = _('ANARC186 1MHz Decrease'), category = _('Communications')},
    {down = Keys.arc186_100khz_up, name = _('ANARC186 100KHz Increase'), category = _('Communications')},
    {down = Keys.arc186_100khz_down, name = _('ANARC186 100KHz Decrease'), category = _('Communications')},
    {down = Keys.arc186_10khz_up, name = _('ANARC186 10KHz Increase'), category = _('Communications')},
    {down = Keys.arc186_10khz_down, name = _('ANARC186 10KHz Decrease'), category = _('Communications')},
    {down = Keys.arc186_mode_inc, name = _('ANARC186 Frequency Mode Increase'), category = _('Communications')},
    {down = Keys.arc186_mode_dec, name = _('ANARC186 Frequency Mode Decrease'), category = _('Communications')},
    {down = Keys.arc186_power_inc, name = _('ANARC186 Mode Increase'), category = _('Communications')},
    {down = Keys.arc186_power_dec, name = _('ANARC186 Mode Decrease'), category = _('Communications')},
    {down = Keys.arc186_wheel_inc, name = _('ANARC186 Preset Increase'), category = _('Communications')},
    {down = Keys.arc186_wheel_dec, name = _('ANARC186 Preset Decrease'), category = _('Communications')},

-- ANARC210
    {pressed = Keys.arc210_vol_inc, name = _('ANARC210 Volume Increase'), category = _('Communications')},
    {pressed = Keys.arc210_vol_dec, name = _('ANARC210 Volume Decrease'), category = _('Communications')},
    {down = Keys.arc210_channel_inc, name = _('ANARC210 Channel Increase'), category = _('Communications')},
    {down = Keys.arc210_channel_dec, name = _('ANARC210 Channel Decrease'), category = _('Communications')},
    {down = Keys.arc210_channel_push, name = _('ANARC210 Channel Push'), category = _('Communications')},
    {down = Keys.arc210_freq_mode_inc, name = _('ANARC210 Frequency Mode Increase'), category = _('Communications')},
    {down = Keys.arc210_freq_mode_dec, name = _('ANARC210 Frequency Mode Decrease'), category = _('Communications')},
    {down = Keys.arc210_mode_inc, name = _('ANARC210 Mode Increase'), category = _('Communications')},
    {down = Keys.arc210_mode_dec, name = _('ANARC210 Mode Decrease'), category = _('Communications')},
    {down = Keys.arc210_button1, name = _('ANARC210 Button -'), category = _('Communications')},
    {down = Keys.arc210_button2, name = _('ANARC210 Button >'), category = _('Communications')},

-- Intercom    
    {down = Keys.intercom_select1, name = _('Intercom Channel 1'), category = _('Communications')},
    {down = Keys.intercom_select2, name = _('Intercom Channel 2'), category = _('Communications')},
    {down = Keys.intercom_select3, name = _('Intercom Channel 3'), category = _('Communications')},
    {down = Keys.inc_intercom_select, name = _('Intercom Channel Increase'), category = _('Communications')},
    {down = Keys.dec_intercom_select, name = _('Intercom Channel Decrease'), category = _('Communications')},
    {pressed = Keys.intercom_vol_inc, name = _('Intercom Volume Increase'), category = _('Communications')},
    {pressed = Keys.intercom_vol_dec, name = _('Intercom Volume Decrease'), category = _('Communications')},
    {pressed = Keys.intercom_mon1_inc, name = _('Intercom Monitor 1 Increase'), category = _('Communications')},
    {pressed = Keys.intercom_mon1_dec, name = _('Intercom Monitor 1 Decrease'), category = _('Communications')},
    {pressed = Keys.intercom_mon2_inc, name = _('Intercom Monitor 2 Increase'), category = _('Communications')},
    {pressed = Keys.intercom_mon2_dec, name = _('Intercom Monitor 2 Decrease'), category = _('Communications')},
    {pressed = Keys.intercom_mon3_inc, name = _('Intercom Monitor 3 Increase'), category = _('Communications')},
    {pressed = Keys.intercom_mon3_dec, name = _('Intercom Monitor 3 Decrease'), category = _('Communications')},
    {down = Keys.intercom_on, name = _('Intercom On'), category = _('Communications')},
    {down = Keys.intercom_off, name = _('Intercom Off'), category = _('Communications')},
    {down = Keys.intercom_onoff_toggle, name = _('Intercom On/Off Toggle'), category = _('Communications')},


-- Weapons 

    {combos = {{key = 'Space'}}, down = Keys.FireOn, up = Keys.FireOff, name = _('Gun Fire'), category = _('Weapons')},
    {combos = {{key = 'Space'}, reformers = {'LShift'}}, down = Keys.RocketFireOn, up = Keys.RocketFireOff, name = _('Rocket Fire'), category = _('Weapons')},

    {combos = {{key = 'A',reformers = {'LCtrl'}}}, down = Keys.Master_arm_on, name = _('Master Arm On'), category = _('Weapons')},
    {combos = {{key = 'A',reformers = {'LAlt'}}}, down = Keys.Master_arm_off, name = _('Master Arm Off'), category = _('Weapons')},
    {combos = {{key = 'A',reformers = {'LWin'}}}, down = Keys.Master_arm_toggle, name = _('Master Arm Toggle'), category = _('Weapons')},

    {down = Keys.left_gun_pwr_on, name = _('Gun Left Power On'), category = _('Weapons')},
    {down = Keys.left_gun_pwr_off, name = _('Gun Left Power Off'), category = _('Weapons')},
    {down = Keys.left_gun_pwr_toggle, name = _('Gun Left Power Toggle'), category = _('Weapons')},
    {down = Keys.left_gun_arm_on, name = _('Gun Left Arm On'), category = _('Weapons')},
    {down = Keys.left_gun_arm_off, name = _('Gun Left Arm Off'), category = _('Weapons')},
    {down = Keys.left_gun_arm_toggle, name = _('Gun Left Arm Toggle'), category = _('Weapons')},
    {down = Keys.left_gun_ftclr_norm, name = _('Gun Left Fire to Clear On'), category = _('Weapons')},
    {down = Keys.left_gun_ftclr_on, name = _('Gun Left Fire to Clear Off'), category = _('Weapons')},
    {down = Keys.left_gun_ftclr_toggle, name = _('Gun Left Fire to Clear Toggle'), category = _('Weapons')},
    {down = Keys.right_gun_pwr_on, name = _('Gun Right Power On'), category = _('Weapons')},
    {down = Keys.right_gun_pwr_off, name = _('Gun Right Power Off'), category = _('Weapons')},
    {down = Keys.right_gun_pwr_toggle, name = _('Gun Right Power Toggle'), category = _('Weapons')},
    {down = Keys.right_gun_arm_on, name = _('Gun Right Arm On'), category = _('Weapons')},
    {down = Keys.right_gun_arm_off, name = _('Gun Right Arm Off'), category = _('Weapons')},
    {down = Keys.right_gun_arm_toggle, name = _('Gun Right Arm Toggle'), category = _('Weapons')},
    {down = Keys.right_gun_ftclr_norm, name = _('Gun Right Fire to Clear On'), category = _('Weapons')},
    {down = Keys.right_gun_ftclr_on, name = _('Gun Right Fire to Clear Off'), category = _('Weapons')},
    {down = Keys.right_gun_ftclr_toggle, name = _('Gun Right Fire to Clear Toggle'), category = _('Weapons')},
    {down = Keys.ams_power_on, name = _('AMS Power On'), category = _('Weapons')},
    {down = Keys.ams_power_off, name = _('AMS Power Off'), category = _('Weapons')},
    {down = Keys.ams_power_toggle, name = _('AMS Power Toggle'), category = _('Weapons')},
    {down = Keys.ams_rockets_ripple_on, name = _('AMS Rockets Ripple On'), category = _('Weapons')},
    {down = Keys.ams_rockets_ripple_off, name = _('AMS Rockets Ripple Off'), category = _('Weapons')},
    {down = Keys.ams_rockets_ripple_toggle, name = _('AMS Rockets Ripple Toggle'), category = _('Weapons')},
    {down = Keys.ams_rockets_single, name = _('AMS Rockets Pair: Single'), category = _('Weapons')},
    {down = Keys.ams_rockets_pair, name = _('AMS Rockets Pair: Pair'), category = _('Weapons')},
    {down = Keys.ams_rockets_pair_toggle, name = _('AMS Rockets Pair Toggle'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_left, name = _('AMS Rockets Side Left'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_right, name = _('AMS Rockets Side Right'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_both, name = _('AMS Rockets Side Both'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_toggle, name = _('AMS Rockets Side Toggle'), category = _('Weapons')},

    {down = Keys.jettison_cover, name = _('Toggle Jettison Cover'), category = _('Weapons')},
    {down = Keys.jettison, name = _('Jettison'), category = _('Weapons')},


    {pressed = Keys.gunsight_up, name = _('Gunsight Up'), category = _('Weapons')},
    {pressed = Keys.gunsight_down, name = _('Gunsight Down'), category = _('Weapons')},

    {combos = {{key = 'M'}}, down = Keys.roe,  name = _('Toggle Door Gunner ROE'), category = _('Weapons')},
    {combos = {{key = 'M',reformers = {'RAlt'}}}, down = Keys.toggle_burst_length,  name = _('Toggle Door Gunner Burst Lenght'), category = _('Weapons')},
    {combos = {{key = 'M',reformers = {'LWin'}}}, down = Keys.toggle_crew_gui,  name = _('Toggle Crew Status'), category = _('Weapons')},
    
    {down = Keys.DropFlare,up = Keys.DropFlare,value_up = 0.0,value_down = 1.0, name = _('Flares/Chaffs Dispense'), category = _('Weapons')},
    {down = Keys.FlareArmSafe, name = _('Flares/Chaffs Arm/Safe'), category = _('Weapons')},
    {down = Keys.FlareArm, name = _('Flares/Chaffs Arm'), category = _('Weapons')},
    {down = Keys.FlareSafe, name = _('Flares/Chaffs Safe'), category = _('Weapons')},

    {down = Keys.drop_g1, name = _('Drop Grenade 1'), category = _('Weapons')},
    {down = Keys.drop_g2, name = _('Drop Grenade 2'), category = _('Weapons')},
    {down = Keys.drop_g3, name = _('Drop Grenade 3'), category = _('Weapons')},
    {down = Keys.drop_g4, name = _('Drop Grenade 4'), category = _('Weapons')},

    {down = Keys.ThrottleIdle, name = _('Throttle Idle'), category = _('Systems')},
	{down = Keys.ThrottleCutoff, name = _('Throttle Cutoff'), category = _('Systems')},	
	{pressed = Keys.ThrottleIncrease, up = Keys.ThrottleStop,  name = _('Throttle Up'), category = _('Systems')},
	{pressed = Keys.ThrottleDecrease, up = Keys.ThrottleStop,  name = _('Throttle Down'), category = _('Systems')},
	
	{down = EFM_commands.collectiveUp,     up = EFM_commands.collectiveUp,   value_up =0.0,value_down = 1.0,name = _('Collective up'), category = _('Systems')},
    {down = EFM_commands.collectiveDown,   up = EFM_commands.collectiveDown, value_up =0.0,value_down = 1.0,name = _('Collective down'), category = _('Systems')},
    {down = EFM_commands.joystickUp,       up = EFM_commands.joystickUp,     value_up =0.0,value_down = 1.0,name = _('Cyclic up'), category = _('Systems')},
    {down = EFM_commands.joystickDown,     up = EFM_commands.joystickDown,   value_up =0.0,value_down = 1.0,name = _('Cyclic down'), category = _('Systems')},
    {down = EFM_commands.joystickLeft,     up = EFM_commands.joystickLeft,   value_up =0.0,value_down = 1.0,name = _('Cyclic left'), category = _('Systems')},
    {down = EFM_commands.joystickRight,    up = EFM_commands.joystickRight,  value_up =0.0,value_down = 1.0,name = _('Cyclic right'), category = _('Systems')},
    {down = EFM_commands.pedalLeft,        up = EFM_commands.pedalLeft,      value_up =0.0,value_down = 1.0,name = _('Pedals left'), category = _('Systems')},
    {down = EFM_commands.pedalRight,       up = EFM_commands.pedalRight,     value_up =0.0,value_down = 1.0,name = _('Pedals right'), category = _('Systems')},

		
	{pressed =  Keys.StarterButton, up = Keys.StarterButtonRelease,  name = _('Starter Button'), category = _('Systems')},
	
	{pressed =  Keys.GovTrimUp, up = Keys.GovTrimUp,  name = _('Govenor Trim up'), category = _('Systems')},
	{pressed =  Keys.GovTrimDown, up = Keys.GovTrimDown,  name = _('Govenor Trim down'), category = _('Systems')},
	
	{pressed = EFM_commands.trimUp, name = _('Cyclic Trim Up'), category = _('Systems')},
	{pressed = EFM_commands.trimDown, name = _('Cyclic Trim Down'), category = _('Systems')},
	{pressed = EFM_commands.trimLeft, name = _('Cyclic Trim Left'), category = _('Systems')},
	{pressed = EFM_commands.trimRight, name = _('Cyclic Trim Right'), category = _('Systems')},
    {down = EFM_commands.trimRelease, up = EFM_commands.trimReleaseRelease, name = _('Cyclic Trim Release'), category = _('Systems')},
    {down = EFM_commands.trimReset, name = _('Cyclic Trim Reset'), category = _('Systems')},
	

-- lights
    {down = Keys.LandingLight, name = _('Landing/Hover Light'), category = _('Systems')},
    {down = Keys.SearchLight, name = _('Search Light'), category = _('Systems')},
    {down = Keys.SearchLightMode, name = _('Toggle Searchlight Mode'), category = _('Systems')},
    {down = Keys.SearchLightUp, up = Keys.SearchLightUpDownRelease, name = _('Searchlight Up'), category = _('Systems')},
    {down = Keys.SearchLightDown, up = Keys.SearchLightUpDownRelease, name = _('Searchlight Down'), category = _('Systems')},
    {down = Keys.SearchLightLeft, up = Keys.SearchLightLeftRightRelease, name = _('Searchlight Left'), category = _('Systems')},
    {down = Keys.SearchLightRight, up = Keys.SearchLightLeftRightRelease, name = _('Searchlight Right'), category = _('Systems')},
	{down = Keys.SearchLightLock, name = _('Searchlight Lock'), category = _('Systems')},

    {pressed = Keys.lights_vids_inc, name = _('Lights VIDs Increase'), category = _('Systems')},
    {pressed = Keys.lights_vids_dec, name = _('Lights VIDs Decrease'), category = _('Systems')},
    {pressed = Keys.lights_rdralt_inc, name = _('Lights Radar Altitude Increase'), category = _('Systems')},
    {pressed = Keys.lights_rdralt_dec, name = _('Lights Radar Altitude Decrease'), category = _('Systems')},
    {pressed = Keys.lights_dhi_inc, name = _('Lights DHI Increase'), category = _('Systems')},
    {pressed = Keys.lights_dhi_dec, name = _('Lights DHI Decrease'), category = _('Systems')},
    {pressed = Keys.lights_fqi_inc, name = _('Lights FQI Increase'), category = _('Systems')},
    {pressed = Keys.lights_fqi_dec, name = _('Lights FQI Decrease'), category = _('Systems')},
    {pressed = Keys.lights_radio_inc, name = _('Lights Radios Increase'), category = _('Systems')},
    {pressed = Keys.lights_radio_dec, name = _('Lights Radios Decrease'), category = _('Systems')},
    {pressed = Keys.lights_ams_inc, name = _('Lights AMS Increase'), category = _('Systems')},
    {pressed = Keys.lights_ams_dec, name = _('Lights AMS Decrease'), category = _('Systems')},
    {pressed = Keys.lights_panels_inc, name = _('Lights Panels Increase'), category = _('Systems')},
    {pressed = Keys.lights_panels_dec, name = _('Lights Panels Decrease'), category = _('Systems')},
    {down = Keys.strobe_top, name = _('Lights Strobe Top'), category = _('Systems')},
    {down = Keys.strobe_both, name = _('Lights Strobe Both'), category = _('Systems')},
    {down = Keys.strobe_topboth_toggle, name = _('Lights Strobe Top/Both Toggle'), category = _('Systems')},
    {down = Keys.strobe_mode_on, name = _('Lights Strobe On'), category = _('Systems')},
    {down = Keys.strobe_mode_off, name = _('Lights Strobe Off'), category = _('Systems')},
    {down = Keys.strobe_mode_toggle, name = _('Lights Strobe On/Off Toggle'), category = _('Systems')},
    {down = Keys.pos_light_on, name = _('Position Lights On'), category = _('Systems')},
    {down = Keys.pos_light_off, name = _('Position Lights Off'), category = _('Systems')},
    {down = Keys.pos_light_toggle, name = _('Position Lights On/Off Toggle'), category = _('Systems')},
    {down = Keys.pos_light_dim_inc, name = _('Position Lights DIM Increase'), category = _('Systems')},
    {down = Keys.pos_light_dim_dec, name = _('Position Lights DIM Decrease'), category = _('Systems')},

    {down = iCommandCockpitClickModeOnOff, name = _('Clickable mouse cockpit mode On/Off'), category = _('General')},

    -- Night Vision Goggles
	{down = iCommandViewNightVisionGogglesOn,	 name = _('Toggle Night Vision Goggles'), 	category = _('NVG')},
	{pressed = iCommandPlane_Helmet_Brightess_Up  , name = _('Gain NVG up')  , category = _('NVG')},
	{pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Gain NVG down'), category = _('NVG')},

-- Multicrew
	{down = iCommandViewCockpitChangeSeat, value_down = 1, name = _('Occupy Pilot Seat'),	category = _('Crew Control')},
	{down = iCommandViewCockpitChangeSeat, value_down = 2, name = _('Occupy Copilot Seat'),	category = _('Crew Control')},	
	{down = iCommandNetCrewRequestControl,	name = _('Request Aircraft Control'),category = _('Crew Control')},
	
	--{combos = {{key = 'P', reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Show Pilot Body'), category = _('General')},

    --{down = Keys.showControlInd, name = _('Show controls indicator'), category = _('General')}, 


    -- Communications
    {down = Keys.ptt, up = Keys.ptt, value_up =0.0,value_down = 1.0,name = _('PTT'), category = _('Communications')},
    {down = Keys.ptt_voice,up = Keys.ptt_voice, value_up =0.0,value_down = 1.0, name = _('PTT VOICE'), category = _('Communications')},

    -- SunVisor Tanuki44
	{down = Keys.sunVisorToggle, name = _('SunVisor UP/DOWN'), category = _('General')},
	-- Sprayer Tanuki44
    {down = Keys.sprayerToggleOn, up = Keys.sprayerToggleOff, name = _('Sprayer ON/OFF'), category = _('Systems')},
    {down = Keys.sprayFilling, name = _('Spray Filling'), category = _('Systems')},
   
    {down = Keys.ams_rockets_side_norm, name = _('AMS Rockets Norm'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_preset, name = _('AMS Rockets Preset'), category = _('Weapons')},
    {down = Keys.ams_rockets_side_set, name = _('AMS Rockets Set'), category = _('Weapons')},	
    
    
   
    {down = EFM_commands.activateRotorBrake, name = _('Rotorbrake on'), category = _('Systems')},
    {down = EFM_commands.deactivateRotorBrake, name = _('Rotorbrake off'), category = _('Systems')},

    {down = Keys.RWROnOffSwitch, name = _('RWR Power toggle'), category = _('Systems')},
    {down = Keys.RWROn, name = _('RWR Power On'), category = _('Systems')},
    {down = Keys.RWROff, name = _('RWR Power Off'), category = _('Systems')},
    {pressed = Keys.RWRLoudnessIncrease, name = _('RWR Loudness Increase'), category = _('Systems')},
    {pressed = Keys.RWRLoudnessDecrease, name = _('RWR Loudness Decrease'), category = _('Systems')},
    {pressed = Keys.RWRBrightnessIncrease, name = _('RWR Brightness Increase'), category = _('Systems')},
    {pressed = Keys.RWRBrightnessDecrease, name = _('RWR Brightness Decrease'), category = _('Systems')},

    -- Argus
    {pressed = Keys.argus_dim_inc, name = _('Argus7000 Brightness Increase'), category = _('Systems')},
    {pressed = Keys.argus_dim_dec, name = _('Argus7000 Brightness Decrease'), category = _('Systems')},
    {down = Keys.argus_power,up = Keys.argus_power, value_down = 1.0,value_up = 0.0, name = _('Argus7000 Power'), category = _('Systems')},
    {down = Keys.argus_dep,up = Keys.argus_dep, value_down = 1.0,value_up = 0.0, name = _('Argus7000 Dep'), category = _('Systems')},
    {down = Keys.argus_enr,up = Keys.argus_enr, value_down = 1.0,value_up = 0.0, name = _('Argus7000 Enr'), category = _('Systems')},
    {down = Keys.argus_arr,up = Keys.argus_arr, value_down = 1.0,value_up = 0.0, name = _('Argus7000 Arr'), category = _('Systems')},
    {down = Keys.argus_aux,up = Keys.argus_aux, value_down = 1.0,value_up = 0.0, name = _('Argus7000 Aux'), category = _('Systems')},


    

	--TNL3100
    {down = Keys.tnl3100_pwr,up = Keys.tnl3100_pwr, value_down = 1.0,value_up = 0.0, name = _('TNL3100 Power'), category = _('Systems')},
    {down = Keys.tnl3100_nav,up = Keys.tnl3100_nav, value_down = 1.0,value_up = 0.0, name = _('TNL3100 Nav'), category = _('Systems')},
    {down = Keys.tnl3100_wpt,up = Keys.tnl3100_wpt, value_down = 1.0,value_up = 0.0, name = _('TNL3100 WPT'), category = _('Systems')},
    {down = Keys.tnl3100_apt_vor,up = Keys.tnl3100_apt_vor, value_down = 1.0,value_up = 0.0, name = _('TNL3100 APT/VOR'), category = _('Systems')},
    {down = Keys.tnl3100_D,up = Keys.tnl3100_D, value_down = 1.0,value_up = 0.0, name = _('TNL3100 D'), category = _('Systems')},
    {down = Keys.tnl3100_fpl,up = Keys.tnl3100_fpl, value_down = 1.0,value_up = 0.0, name = _('TNL3100 FPL'), category = _('Systems')},
    {down = Keys.tnl3100_calc,up = Keys.tnl3100_calc, value_down = 1.0,value_up = 0.0, name = _('TNL3100 CALC'), category = _('Systems')},
    {down = Keys.tnl3100_aux,up = Keys.tnl3100_aux, value_down = 1.0,value_up = 0.0, name = _('TNL3100 AUX'), category = _('Systems')},
    {down = Keys.tnl3100_msg,up = Keys.tnl3100_msg, value_down = 1.0,value_up = 0.0, name = _('TNL3100 MSG'), category = _('Systems')},
    {down = Keys.tnl3100_ent,up = Keys.tnl3100_ent, value_down = 1.0,value_up = 0.0, name = _('TNL3100 ENT'), category = _('Systems')},
    {up = Keys.tnl3100_inner_inc, name = _('TNL3100 Inner Rotary increase'), category = _('Systems')},
    {up = Keys.tnl3100_inner_dec, name = _('TNL3100 Inner Rotary decrease'), category = _('Systems')},
    {up = Keys.tnl3100_outer_inc, name = _('TNL3100 Outer Rotary increase'), category = _('Systems')},
    {up = Keys.tnl3100_outer_dec, name = _('TNL3100 Outer Rotary decrease'), category = _('Systems')},

    {down  = Keys.drop_gunner,value_down = 1.0,name = _('Deploy Gunner'), category = _('Weapons')},	   
})

-- joystick axis 
join(res.axisCommands,{
    {combos = defaultDeviceAssignmentFor("roll")	, action = iCommandPlaneRoll,			name = _('Roll Cyclic')},
    {combos = defaultDeviceAssignmentFor("pitch")	, action = iCommandPlanePitch,			name = _('Pitch Cyclic')},
    {combos = defaultDeviceAssignmentFor("rudder")	, action = iCommandPlaneRudder, 		name = _('Pedals')},
    {combos = defaultDeviceAssignmentFor("thrust")	, action = iCommandPlaneThrustCommon,	name = _('Collective')},
    {combos = defaultDeviceAssignmentFor("throttle"), action = Keys.throttleAxis,	name = _('Throttle')},
    {combos = defaultDeviceAssignmentFor("searchlightXAxis"), action = Keys.SearchlightXAxis,	name = _('Searchlight Left/Right')},
    {combos = defaultDeviceAssignmentFor("searchlightYAxis"), action = Keys.SearchlightYAxis,	name = _('Searchlight Up/Down')},
})

return res
